<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Project;
use Illuminate\Http\Request;
use Str;

class ProjectController extends Controller
{
    public function index()
    {
        return view('admin.projects.index', [
            'projects' => Project::latest()->get()
        ]);
    }

    public function create()
    {
        return view('admin.projects.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'title' => 'required',
            'description' => 'required',
            'client' => 'nullable',
            'url' => 'nullable|url',
        ]);

        $data['slug'] = Str::slug($request->title);

        Project::create($data);

        return redirect()->route('admin.projects')->with('success', 'Project added');
    }
}
