@extends('layouts.admin')

@section('title', 'Portfolio | KodeHub Admin')
@section('page_title', 'Portfolio Projects')

@section('content')

<div style="display:flex; align-items:center; justify-content:space-between; margin-bottom:1.5rem;">
    <p style="font-size:0.9375rem; color:var(--ink-muted);">Manage your portfolio case studies.</p>
    <a href="{{ url('/admin/projects/create') }}" class="admin-btn admin-btn--primary">
        <i class="fa-solid fa-plus fa-xs"></i>
        Add Project
    </a>
</div>

<div class="admin-card">
    @if($projects->isEmpty())
        <div style="text-align:center; padding:3rem; color:var(--ink-muted);">
            <i class="fa-solid fa-briefcase" style="font-size:2rem; margin-bottom:1rem; display:block; color:var(--ink-faint);"></i>
            No projects yet. Add your first one.
        </div>
    @else
        <table class="admin-table">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Client</th>
                    <th>URL</th>
                    <th>Added</th>
                </tr>
            </thead>
            <tbody>
                @foreach($projects as $project)
                <tr>
                    <td style="font-weight:400;">{{ $project->title }}</td>
                    <td style="color:var(--ink-muted);">{{ $project->client }}</td>
                    <td>
                        @if($project->url)
                            <a href="{{ $project->url }}" target="_blank"
                               style="font-size:0.875rem; color:var(--accent);">
                                {{ parse_url($project->url, PHP_URL_HOST) }}
                                <i class="fa-solid fa-arrow-up-right-from-square fa-xs" style="margin-left:0.25rem;"></i>
                            </a>
                        @else
                            <span style="color:var(--ink-faint);">—</span>
                        @endif
                    </td>
                    <td style="color:var(--ink-muted); font-size:0.875rem;">
                        {{ $project->created_at->format('d M Y') }}
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>

@endsection