<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Admin | KodeHub')</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script src="https://kit.fontawesome.com/9b1965001a.js" crossorigin="anonymous"></script>
    <style>
        /* Admin-specific overrides */
        .admin-layout { display:flex; min-height:100dvh; background:#f4f4f2; }
        .admin-sidebar {
            width:240px;
            background:var(--ink);
            display:flex;
            flex-direction:column;
            flex-shrink:0;
            position:sticky;
            top:0;
            height:100dvh;
        }
        .admin-sidebar__logo {
            display:flex;
            align-items:center;
            gap:0.625rem;
            padding:1.5rem 1.5rem 1.25rem;
            font-family:var(--font-display);
            font-size:1.125rem;
            color:white;
            border-bottom:1px solid rgba(255,255,255,0.08);
            margin-bottom:1.25rem;
        }
        .admin-nav { flex:1; padding:0 0.75rem; }
        .admin-nav__label {
            font-family:var(--font-mono);
            font-size:0.5625rem;
            letter-spacing:0.14em;
            text-transform:uppercase;
            color:rgba(255,255,255,0.25);
            padding:0 0.75rem;
            margin-bottom:0.5rem;
            display:block;
        }
        .admin-nav__link {
            display:flex;
            align-items:center;
            gap:0.75rem;
            padding:0.625rem 0.75rem;
            color:rgba(255,255,255,0.55);
            font-size:0.9375rem;
            font-weight:300;
            border-radius:0;
            transition:all 0.15s;
            margin-bottom:2px;
        }
        .admin-nav__link i { font-size:0.875rem; width:1rem; text-align:center; }
        .admin-nav__link:hover { color:rgba(255,255,255,0.9); background:rgba(255,255,255,0.05); }
        .admin-nav__link.active { color:white; background:rgba(255,255,255,0.1); }
        .admin-sidebar__footer { padding:1.25rem 1.5rem; border-top:1px solid rgba(255,255,255,0.08); }
        .admin-logout {
            display:flex;
            align-items:center;
            gap:0.625rem;
            font-size:0.875rem;
            color:rgba(255,255,255,0.4);
            cursor:pointer;
            transition:color 0.15s;
            background:none;
            border:none;
            font-family:var(--font-body);
            font-weight:300;
            width:100%;
        }
        .admin-logout:hover { color:rgba(255,255,255,0.75); }
        .admin-main { flex:1; display:flex; flex-direction:column; overflow:hidden; }
        .admin-topbar {
            height:60px;
            background:white;
            border-bottom:1px solid var(--rule);
            display:flex;
            align-items:center;
            padding:0 2rem;
            gap:1rem;
        }
        .admin-topbar__title {
            font-size:0.9375rem;
            font-weight:400;
            color:var(--ink-muted);
        }
        .admin-content { flex:1; padding:2rem; overflow-y:auto; }
        .admin-card {
            background:white;
            border:1px solid var(--rule);
            padding:1.5rem;
        }
        .admin-stat-card {
            background:white;
            border:1px solid var(--rule);
            padding:1.5rem 2rem;
        }
        .admin-stat-card__label {
            font-family:var(--font-mono);
            font-size:0.625rem;
            letter-spacing:0.12em;
            text-transform:uppercase;
            color:var(--ink-muted);
            margin-bottom:0.75rem;
        }
        .admin-stat-card__num {
            font-family:var(--font-display);
            font-size:2.25rem;
            font-weight:400;
            color:var(--ink);
            letter-spacing:-0.03em;
        }
        .admin-table { width:100%; border-collapse:collapse; }
        .admin-table th {
            font-family:var(--font-mono);
            font-size:0.625rem;
            letter-spacing:0.12em;
            text-transform:uppercase;
            color:var(--ink-muted);
            padding:0.75rem 1rem;
            text-align:left;
            border-bottom:1px solid var(--rule);
        }
        .admin-table td {
            padding:0.875rem 1rem;
            font-size:0.9375rem;
            border-bottom:1px solid var(--rule);
            vertical-align:middle;
        }
        .admin-table tr:last-child td { border-bottom:none; }
        .admin-table tr:hover td { background:#fafaf8; }
        .admin-badge {
            display:inline-block;
            font-size:0.75rem;
            font-weight:400;
            padding:0.25rem 0.625rem;
            background:var(--accent-pale);
            color:var(--accent-dark);
        }
        .admin-btn {
            display:inline-flex;
            align-items:center;
            gap:0.5rem;
            font-size:0.8125rem;
            font-weight:400;
            letter-spacing:0.05em;
            text-transform:uppercase;
            padding:0.625rem 1.25rem;
            transition:all 0.2s;
            cursor:pointer;
            font-family:var(--font-body);
        }
        .admin-btn--primary {
            background:var(--accent);
            color:white;
            border:1px solid var(--accent);
        }
        .admin-btn--primary:hover { background:var(--accent-dark); border-color:var(--accent-dark); }
        .admin-btn--outline {
            border:1px solid var(--rule-strong);
            color:var(--ink);
        }
        .admin-btn--outline:hover { background:var(--ink); color:white; border-color:var(--ink); }

        @media (max-width:768px) {
            .admin-sidebar { display:none; }
        }
    </style>
</head>
<body>

<div class="admin-layout">

    <aside class="admin-sidebar">
        <div class="admin-sidebar__logo">
            <div class="logo-mark">KH</div>
            KodeHub
        </div>

        <nav class="admin-nav">
            <span class="admin-nav__label">Navigation</span>
            <a href="{{ route('admin.dashboard') }}" class="admin-nav__link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                <i class="fa-solid fa-chart-simple"></i>
                Dashboard
            </a>
            <a href="{{ route('admin.projects') }}" class="admin-nav__link {{ request()->routeIs('admin.projects*') ? 'active' : '' }}">
                <i class="fa-solid fa-briefcase"></i>
                Portfolio
            </a>
            <a href="{{ route('admin.messages') }}" class="admin-nav__link {{ request()->routeIs('admin.messages*') ? 'active' : '' }}">
                <i class="fa-solid fa-inbox"></i>
                Messages
            </a>
            <a href="{{ route('welcome') }}" class="admin-nav__link" target="_blank">
                <i class="fa-solid fa-arrow-up-right-from-square"></i>
                View Site
            </a>
        </nav>

        <div class="admin-sidebar__footer">
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button class="admin-logout" type="submit">
                    <i class="fa-solid fa-right-from-bracket"></i>
                    Sign Out
                </button>
            </form>
        </div>
    </aside>

    <div class="admin-main">
        <div class="admin-topbar">
            <p class="admin-topbar__title">@yield('page_title', 'Dashboard')</p>
        </div>
        <div class="admin-content">
            @yield('content')
        </div>
    </div>

</div>

</body>
</html>