<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <title>@yield('title', 'KodeHub | Bespoke Software Development — Nairobi, Kenya')</title>
    <meta name="description" content="@yield('meta_description', 'KodeHub crafts bespoke web applications, mobile platforms, and enterprise systems for discerning organizations across Kenya and beyond.')">
    <meta name="keywords" content="web development kenya, mobile app development nairobi, ERP systems kenya, POS systems, Laravel development, custom software kenya">
    <meta name="author" content="KodeHub">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="{{ url()->current() }}">

    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:title" content="@yield('title', 'KodeHub | Bespoke Software Development')">
    <meta property="og:description" content="@yield('meta_description', 'Bespoke web applications, mobile platforms, and enterprise systems.')">

    <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <script src="https://kit.fontawesome.com/9b1965001a.js" crossorigin="anonymous"></script>

    @stack('styles')
</head>
<body>

    @include('partials.header')

    <main>
        @yield('content')
    </main>

    @include('partials.footer')

    <script>
        // Scroll reveal
        (function() {
            const observer = new IntersectionObserver(function(entries) {
                entries.forEach(function(entry) {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('in-view');
                    }
                });
            }, { threshold: 0.08, rootMargin: '0px 0px -60px 0px' });

            function init() {
                document.querySelectorAll('.reveal').forEach(function(el) {
                    observer.observe(el);
                });
            }

            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', init);
            } else {
                init();
            }
        })();
    </script>

    @stack('scripts')

</body>
</html>