@extends('layouts.app')

@section('title', 'KodeHub | Bespoke Software Development — Web, Mobile & Enterprise Systems')
@section('meta_description', 'KodeHub crafts sophisticated web applications, mobile platforms, and enterprise systems for discerning organizations across Kenya and beyond.')

@section('content')

{{-- ============================================================
     HERO
============================================================ --}}
<section class="hero">
    <div class="hero__bg">
        <img src="https://images.unsplash.com/photo-1497366216548-37526070297c?q=85&w=2070&auto=format&fit=crop"
             alt="Modern office workspace"
             loading="eager"
             fetchpriority="high">
        <div class="hero__overlay"></div>
        <div class="hero__grain"></div>
    </div>

    <div class="hero__content">

        <div class="hero__eyebrow">
            <span class="eyebrow" style="color:rgba(212,149,106,0.9);">Est. 2019 &mdash; Kiambu, Kenya</span>
            <span class="hero__eyebrow-line"></span>
        </div>

        <h1 class="display-1 hero__title">
            We craft digital<br>
            products that <em>endure.</em>
        </h1>

        <p class="hero__subtitle">
            Bespoke web platforms, mobile applications, and enterprise systems—
            engineered for organizations that refuse to compromise on quality.
        </p>

        <div class="hero__actions">
            <a href="{{ route('contact') }}" class="btn btn-primary">
                Begin a Project
                <i class="fa-solid fa-arrow-right fa-xs"></i>
            </a>
            <a href="{{ route('portfolio') }}" class="btn btn-outline--light">
                View Our Work
            </a>
        </div>

        <div class="hero__stats">
            <div>
                <div class="hero__stat-num">50+</div>
                <div class="hero__stat-label">Projects Delivered</div>
            </div>
            <div>
                <div class="hero__stat-num">30+</div>
                <div class="hero__stat-label">Satisfied Clients</div>
            </div>
            <div>
                <div class="hero__stat-num">100%</div>
                <div class="hero__stat-label">Retention Rate</div>
            </div>
            <div>
                <div class="hero__stat-num">5 Yrs</div>
                <div class="hero__stat-label">In Business</div>
            </div>
        </div>

    </div>

    <div class="scroll-cue">
        Scroll
        <span class="scroll-cue__line"></span>
    </div>
</section>

{{-- ============================================================
     MARQUEE STRIP
============================================================ --}}
<div class="marquee-strip">
    <div class="marquee-track">
        @php
            $items = ['Web Development', 'Mobile Applications', 'Enterprise ERP', 'POS Systems', 'Laravel', 'React Native', 'Cloud Infrastructure', 'API Architecture', 'UI Design'];
            $all = array_merge($items, $items, $items, $items);
        @endphp
        @foreach($all as $item)
            <span class="marquee-item">
                {{ $item }}
                <span class="sep"><i class="fa-solid fa-diamond fa-2xs"></i></span>
            </span>
        @endforeach
    </div>
</div>

{{-- ============================================================
     SERVICES
============================================================ --}}
<section class="section bg-paper-cool">
    <div class="container">

        <div class="section-header reveal">
            <span class="eyebrow">Our Expertise</span>
            <h2 class="section-title">What we build</h2>
            <p class="section-lead">
                From concept through deployment and beyond—every engagement is handled
                with the same rigorous attention to craft and strategic clarity.
            </p>
        </div>

        <div class="services-grid">

            <div class="service-card reveal">
                <span class="service-card__num">01</span>
                <div class="service-card__icon">
                    <i class="fa-solid fa-code"></i>
                </div>
                <h3 class="service-card__title">Web Development</h3>
                <p class="service-card__desc">
                    Sophisticated web platforms built on Laravel and modern frameworks.
                    Fast, secure, and designed for long-term maintainability and scale.
                </p>
                <a href="{{ route('services') }}" class="btn btn-ghost">
                    Learn more <i class="fa-solid fa-arrow-right"></i>
                </a>
            </div>

            <div class="service-card reveal reveal-delay-1">
                <span class="service-card__num">02</span>
                <div class="service-card__icon">
                    <i class="fa-solid fa-mobile-screen-button"></i>
                </div>
                <h3 class="service-card__title">Mobile Applications</h3>
                <p class="service-card__desc">
                    Cross-platform mobile solutions delivering native-grade performance
                    on iOS and Android from a unified, maintainable codebase.
                </p>
                <a href="{{ route('services') }}" class="btn btn-ghost">
                    Learn more <i class="fa-solid fa-arrow-right"></i>
                </a>
            </div>

            <div class="service-card reveal reveal-delay-2">
                <span class="service-card__num">03</span>
                <div class="service-card__icon">
                    <i class="fa-solid fa-diagram-project"></i>
                </div>
                <h3 class="service-card__title">Enterprise Systems</h3>
                <p class="service-card__desc">
                    Custom ERP solutions built around your workflows—centralizing operations,
                    eliminating manual processes, and surfacing actionable intelligence.
                </p>
                <a href="{{ route('services') }}" class="btn btn-ghost">
                    Learn more <i class="fa-solid fa-arrow-right"></i>
                </a>
            </div>

            <div class="service-card reveal reveal-delay-3">
                <span class="service-card__num">04</span>
                <div class="service-card__icon">
                    <i class="fa-solid fa-cash-register"></i>
                </div>
                <h3 class="service-card__title">Point of Sale</h3>
                <p class="service-card__desc">
                    Robust POS platforms with real-time inventory, detailed analytics,
                    and offline capability—engineered for demanding retail environments.
                </p>
                <a href="{{ route('services') }}" class="btn btn-ghost">
                    Learn more <i class="fa-solid fa-arrow-right"></i>
                </a>
            </div>

        </div>

    </div>
</section>

{{-- ============================================================
     SELECTED WORK
============================================================ --}}
<section class="section bg-paper-warm border-top">
    <div class="container">

        <div style="display:flex; align-items:flex-end; justify-content:space-between; flex-wrap:wrap; gap:1.5rem; margin-bottom:clamp(2.5rem,5vw,4rem);" class="reveal">
            <div>
                <span class="eyebrow">Selected Work</span>
                <h2 class="section-title" style="margin-bottom:0;">Recent projects</h2>
            </div>
            <a href="{{ route('portfolio') }}" class="btn btn-ghost" style="margin-bottom:0.25rem;">
                View all projects <i class="fa-solid fa-arrow-right"></i>
            </a>
        </div>

        <div class="work-grid">

            <a href="{{ route('portfolio.picforest') }}" class="work-card work-card--large reveal">
                <img src="https://images.unsplash.com/photo-1542744173-8e7e53415bb0?q=80&w=2070&auto=format&fit=crop"
                     alt="Picforest Photography Platform"
                     class="work-card__img">
                <div class="work-card__body">
                    <div class="work-card__category">Photography Platform</div>
                    <h3 class="work-card__title">Picforest Photography</h3>
                    <span class="work-card__link">
                        View Case Study <i class="fa-solid fa-arrow-right fa-xs"></i>
                    </span>
                </div>
            </a>

            <div style="display:grid; grid-template-rows:1fr 1fr; gap:1.5rem;" class="work-card--small">
                <a href="{{ route('portfolio.amicabre') }}" class="work-card reveal reveal-delay-1">
                    <img src="https://images.unsplash.com/photo-1449965408869-eaa3f722e40d?q=80&w=1200&auto=format&fit=crop"
                         alt="Amicabre Travels Fleet System"
                         class="work-card__img" style="aspect-ratio:16/9;">
                    <div class="work-card__body">
                        <div class="work-card__category">Fleet Management</div>
                        <h3 class="work-card__title">Amicabre Travels</h3>
                        <span class="work-card__link">
                            View Case Study <i class="fa-solid fa-arrow-right fa-xs"></i>
                        </span>
                    </div>
                </a>

                <a href="{{ route('portfolio.staffhub') }}" class="work-card reveal reveal-delay-2">
                    <img src="https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?q=80&w=1200&auto=format&fit=crop"
                         alt="StaffHub HR Platform"
                         class="work-card__img" style="aspect-ratio:16/9;">
                    <div class="work-card__body">
                        <div class="work-card__category">HR Management</div>
                        <h3 class="work-card__title">StaffHub</h3>
                        <span class="work-card__link">
                            View Case Study <i class="fa-solid fa-arrow-right fa-xs"></i>
                        </span>
                    </div>
                </a>
            </div>

        </div>

    </div>
</section>

{{-- ============================================================
     APPROACH / WHY CHOOSE US
============================================================ --}}
<section class="section bg-paper-cool border-top">
    <div class="container">

        <div class="section-header--center reveal">
            <span class="eyebrow">Our Approach</span>
            <h2 class="section-title">Why partner with KodeHub</h2>
            <p class="section-lead">
                In a market saturated with fast, cheap output, we've chosen to compete
                on craft, longevity, and genuine strategic partnership.
            </p>
        </div>

        <div class="values-grid">
            <div class="value-card reveal">
                <div class="value-card__icon">
                    <i class="fa-solid fa-sitemap"></i>
                </div>
                <h3 class="value-card__title">Business-First Thinking</h3>
                <p class="value-card__desc">
                    Every engagement begins with a deep understanding of your objectives,
                    constraints, and users—technology follows strategy, never the reverse.
                </p>
            </div>

            <div class="value-card reveal reveal-delay-1">
                <div class="value-card__icon">
                    <i class="fa-solid fa-shield-halved"></i>
                </div>
                <h3 class="value-card__title">Security by Design</h3>
                <p class="value-card__desc">
                    Security is woven into the fabric of our architecture—authentication,
                    data protection, and audit trails are never afterthoughts.
                </p>
            </div>

            <div class="value-card reveal reveal-delay-2">
                <div class="value-card__icon">
                    <i class="fa-solid fa-arrow-up-right-dots"></i>
                </div>
                <h3 class="value-card__title">Built to Scale</h3>
                <p class="value-card__desc">
                    Our systems are architected to grow gracefully—from your first hundred
                    users to your hundred-thousandth, without costly rewrites.
                </p>
            </div>

            <div class="value-card reveal">
                <div class="value-card__icon">
                    <i class="fa-solid fa-comments"></i>
                </div>
                <h3 class="value-card__title">Transparent Partnership</h3>
                <p class="value-card__desc">
                    Clear communication, honest timelines, no hidden costs. We treat
                    every client as a long-term partner, not a one-off transaction.
                </p>
            </div>

            <div class="value-card reveal reveal-delay-1">
                <div class="value-card__icon">
                    <i class="fa-solid fa-gauge-high"></i>
                </div>
                <h3 class="value-card__title">Performance Obsessed</h3>
                <p class="value-card__desc">
                    Sub-second load times, optimized queries, efficient caching—
                    your users will feel the difference without ever knowing why.
                </p>
            </div>

            <div class="value-card reveal reveal-delay-2">
                <div class="value-card__icon">
                    <i class="fa-solid fa-headset"></i>
                </div>
                <h3 class="value-card__title">Ongoing Support</h3>
                <p class="value-card__desc">
                    Deployment is the beginning, not the end. We remain engaged
                    through maintenance, updates, and strategic evolution.
                </p>
            </div>
        </div>

    </div>
</section>

{{-- ============================================================
     CTA BANNER
============================================================ --}}
<div class="cta-banner">
    <div class="cta-banner__inner">
        <h2 class="cta-banner__title">
            Ready to build something
            <em>exceptional?</em>
        </h2>
        <div style="display:flex; gap:1rem; flex-wrap:wrap;">
            <a href="{{ route('contact') }}" class="btn btn-primary">
                Schedule a Consultation
                <i class="fa-solid fa-arrow-right fa-xs"></i>
            </a>
            <a href="{{ route('portfolio') }}" class="btn btn-outline--light">
                View Our Work
            </a>
        </div>
    </div>
</div>

@endsection