

<?php $__env->startSection('title', 'StaffHub | KodeHub Portfolio'); ?>
<?php $__env->startSection('meta_description', 'How KodeHub built StaffHub—a complete HR and payroll management system built on Laravel and PostgreSQL for modern workforce management.'); ?>

<?php $__env->startSection('content'); ?>


<section class="project-hero">
    <div class="project-hero-bg">
        <img src="https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?q=80&w=2070&auto=format&fit=crop" 
             alt="HR Management"
             style="width:100%; height:100%; object-fit:cover;">
    </div>
    <div class="project-hero-overlay"></div>

    <div class="container project-hero-content">

        <a href="<?php echo e(route('portfolio')); ?>" class="back-link" style="color: rgba(255,255,255,0.65); margin-bottom: 2.5rem; display: inline-flex;">
            <i class="fa-solid fa-arrow-left"></i> Back to Portfolio
        </a>

        <div class="project-hero-tag">
            <i class="fa-solid fa-users"></i>
            HR &amp; Payroll System
        </div>

        <h1 class="project-hero-title">StaffHub</h1>
        <p class="project-hero-subtitle">
            A comprehensive HR and payroll management platform that centralises employee 
            records, streamlines attendance tracking, automates payroll processing, 
            and delivers real-time workforce reporting.
        </p>

    </div>
</section>


<div class="project-meta-strip">
    <div class="container">
        <div class="project-meta-grid">
            <div class="project-meta-item">
                <p class="project-meta-label">Product</p>
                <p class="project-meta-value">StaffHub</p>
            </div>
            <div class="project-meta-item">
                <p class="project-meta-label">Category</p>
                <p class="project-meta-value">Enterprise / ERP</p>
            </div>
            <div class="project-meta-item">
                <p class="project-meta-label">Tech Stack</p>
                <p class="project-meta-value">Laravel · Tailwind · PostgreSQL</p>
            </div>
            <div class="project-meta-item">
                <p class="project-meta-label">Live Website</p>
                <p class="project-meta-value">
                    <a href="https://staffhub.co.ke" target="_blank" rel="noopener"
                       style="color: var(--color-primary-light); text-decoration: none;">
                        staffhub.co.ke <i class="fa-solid fa-arrow-up-right-from-square" style="font-size: 0.875rem;"></i>
                    </a>
                </p>
            </div>
        </div>
    </div>
</div>


<section class="section bg-cream" style="background-color: var(--color-cream);">
    <div class="container">
        <div class="project-body">

            
            <div class="project-main">

                
                <div class="project-section fade-in-up">
                    <p class="project-section-eyebrow">Overview</p>
                    <h2 class="project-section-title">The Brief</h2>
                    <p class="project-section-text">
                        Growing businesses in Kenya face a common inflection point: the 
                        moment when managing people across spreadsheets and manual processes 
                        becomes a liability. Payroll errors, missed leave requests, incomplete 
                        records, and compliance gaps begin to cost more than the infrastructure 
                        to fix them.
                    </p>
                    <p class="project-section-text">
                        StaffHub was conceived to be that infrastructure—a single, well-designed 
                        platform where HR teams can manage the full employee lifecycle, process 
                        payroll with confidence, and get instant visibility into workforce data.
                    </p>
                </div>

                
                <div class="project-section fade-in-up">
                    <p class="project-section-eyebrow">Challenge</p>
                    <h2 class="project-section-title">The Problem to Solve</h2>
                    <p class="project-section-text">
                        HR systems are notoriously complex to build well. The rules governing 
                        payroll—statutory deductions, overtime, leave entitlements, contract 
                        types—differ by employee, by role, and change with regulation. A system 
                        that handles these rules incorrectly doesn't just inconvenience staff; 
                        it creates legal and financial exposure.
                    </p>
                    <ul class="result-list" style="margin-top: var(--spacing-lg);">
                        <li class="result-item">
                            <div class="result-icon"><i class="fa-solid fa-calculator"></i></div>
                            <p class="result-text">Payroll processing needed to account for KRA tax brackets, NHIF, NSSF, and custom deductions—automatically and accurately.</p>
                        </li>
                        <li class="result-item">
                            <div class="result-icon"><i class="fa-solid fa-user-clock"></i></div>
                            <p class="result-text">Leave management had to support multiple leave types, accrual rules, and manager-approval workflows without manual overhead.</p>
                        </li>
                        <li class="result-item">
                            <div class="result-icon"><i class="fa-solid fa-shield-halved"></i></div>
                            <p class="result-text">Role-based access was essential—HR admins, line managers, and employees each needed different views and permissions.</p>
                        </li>
                        <li class="result-item">
                            <div class="result-icon"><i class="fa-solid fa-file-invoice"></i></div>
                            <p class="result-text">End-of-month payslip generation and compliance reports needed to be exportable with a single action.</p>
                        </li>
                    </ul>
                </div>

                
                <div class="project-section fade-in-up">
                    <p class="project-section-eyebrow">Our Solution</p>
                    <h2 class="project-section-title">What We Built</h2>
                    <p class="project-section-text">
                        StaffHub is a full-featured Laravel application backed by a PostgreSQL 
                        database, built with a modular architecture that allows each HR function 
                        to operate independently while remaining deeply integrated. The UI is 
                        built with Tailwind CSS, providing a clean, responsive interface that 
                        HR teams find genuinely comfortable to use every day.
                    </p>
                    <p class="project-section-text">
                        The payroll engine calculates gross pay, applies all statutory and 
                        voluntary deductions in the correct sequence, and generates payslip 
                        records that can be reviewed before finalisation—preventing errors 
                        before they reach employee bank accounts. The leave module supports 
                        full policy configuration: accrual rates, carry-over limits, and 
                        multi-step approval chains.
                    </p>
                    <p class="project-section-text">
                        A granular role-permission system ensures that sensitive salary data 
                        is only accessible to authorised users, while employees can self-serve 
                        their own records, payslips, and leave balances through a dedicated 
                        staff portal.
                    </p>
                </div>

                
                <div class="project-section fade-in-up">
                    <p class="project-section-eyebrow">Key Features</p>
                    <h2 class="project-section-title">What It Does</h2>
                    <ul class="result-list">
                        <li class="result-item">
                            <div class="result-icon"><i class="fa-solid fa-id-card"></i></div>
                            <p class="result-text"><strong style="color: var(--text-primary);">Employee Records</strong> — Centralised profiles covering contracts, documents, emergency contacts, and employment history.</p>
                        </li>
                        <li class="result-item">
                            <div class="result-icon"><i class="fa-solid fa-money-bill-wave"></i></div>
                            <p class="result-text"><strong style="color: var(--text-primary);">Automated Payroll</strong> — KRA-compliant calculations with payslip generation, bank export files, and audit trails.</p>
                        </li>
                        <li class="result-item">
                            <div class="result-icon"><i class="fa-solid fa-calendar-days"></i></div>
                            <p class="result-text"><strong style="color: var(--text-primary);">Leave Management</strong> — Multi-type leave tracking with policy configuration and manager approval workflows.</p>
                        </li>
                        <li class="result-item">
                            <div class="result-icon"><i class="fa-solid fa-chart-pie"></i></div>
                            <p class="result-text"><strong style="color: var(--text-primary);">Reporting Dashboard</strong> — Real-time headcount, payroll cost, leave utilization, and compliance summaries.</p>
                        </li>
                    </ul>
                </div>

                
                <div class="project-section fade-in-up">
                    <p class="project-section-eyebrow">Technology</p>
                    <h2 class="project-section-title">Built With</h2>
                    <ul class="tech-list">
                        <li class="tech-pill">
                            <i class="fa-brands fa-laravel"></i> Laravel
                        </li>
                        <li class="tech-pill">
                            <i class="fa-brands fa-css3-alt"></i> Tailwind CSS
                        </li>
                        <li class="tech-pill">
                            <i class="fa-solid fa-database"></i> PostgreSQL
                        </li>
                        <li class="tech-pill">
                            <i class="fa-brands fa-php"></i> PHP 8.x
                        </li>
                        <li class="tech-pill">
                            <i class="fa-solid fa-key"></i> Role-Based Access Control
                        </li>
                        <li class="tech-pill">
                            <i class="fa-solid fa-file-pdf"></i> PDF Export
                        </li>
                    </ul>
                </div>

            </div>

            
            <aside class="project-sidebar">

                
                <div class="sidebar-card fade-in-up">
                    <h3 class="sidebar-card-title">View the Live Platform</h3>
                    <p style="color: var(--text-secondary); font-size: 0.9375rem; line-height: 1.75; margin-bottom: var(--spacing-md);">
                        StaffHub is live and helping businesses manage their teams efficiently.
                    </p>
                    <a href="https://staffhub.co.ke" target="_blank" rel="noopener" class="btn-visit">
                        Visit staffhub.co.ke
                        <i class="fa-solid fa-arrow-up-right-from-square"></i>
                    </a>
                </div>

                
                <div class="sidebar-card fade-in-up">
                    <h3 class="sidebar-card-title">Project Details</h3>
                    <div class="sidebar-stat">
                        <span class="sidebar-stat-label">Deliverable</span>
                        <span class="sidebar-stat-value">SaaS Platform</span>
                    </div>
                    <div class="sidebar-stat">
                        <span class="sidebar-stat-label">Industry</span>
                        <span class="sidebar-stat-value">HR / Enterprise</span>
                    </div>
                    <div class="sidebar-stat">
                        <span class="sidebar-stat-label">Platform</span>
                        <span class="sidebar-stat-value">Web App</span>
                    </div>
                    <div class="sidebar-stat">
                        <span class="sidebar-stat-label">Location</span>
                        <span class="sidebar-stat-value">Kenya</span>
                    </div>
                </div>

                
                <div class="sidebar-card fade-in-up" style="background: linear-gradient(135deg, #9A5D43, #C17C5D); border: none;">
                    <h3 style="font-family: 'Cormorant Garamond', serif; font-size: 1.5rem; font-weight: 300; color: white; margin-bottom: 0.75rem;">Need a system like this?</h3>
                    <p style="color: rgba(255,255,255,0.85); font-size: 0.9375rem; line-height: 1.7; margin-bottom: var(--spacing-md);">
                        We build custom ERP and HR systems tailored to how your business works.
                    </p>
                    <a href="<?php echo e(route('contact')); ?>" class="btn-visit" style="background-color: rgba(255,255,255,0.15); border: 1px solid rgba(255,255,255,0.3);">
                        Get in Touch
                        <i class="fa-solid fa-arrow-right"></i>
                    </a>
                </div>

            </aside>

        </div>
    </div>
</section>


<section class="section bg-light">
    <div class="container">
        <div class="section-header fade-in-up">
            <div class="section-badge">More Work</div>
            <h2 class="section-title">Other Projects</h2>
        </div>
        <div class="other-projects-grid">

            <a href="<?php echo e(route('portfolio.picforest')); ?>" class="project-card fade-in-up">
                <img src="https://images.unsplash.com/photo-1542038784456-1ea8e935640e?q=80&w=2070&auto=format&fit=crop"
                     alt="Photography Platform"
                     style="width: 100%; height: 280px; object-fit: cover;">
                <div class="project-content">
                    <h3 class="project-title">Picforest Photography</h3>
                    <p class="project-description">High-performance photography portfolio website.</p>
                </div>
            </a>

            <a href="<?php echo e(route('portfolio.amicabre')); ?>" class="project-card fade-in-up">
                <img src="https://images.unsplash.com/photo-1449965408869-eaa3f722e40d?q=80&w=2070&auto=format&fit=crop"
                     alt="Fleet Management"
                     style="width: 100%; height: 280px; object-fit: cover;">
                <div class="project-content">
                    <h3 class="project-title">Amicabre Travels</h3>
                    <p class="project-description">Employee transport & fleet management platform.</p>
                </div>
            </a>

        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) entry.target.classList.add('visible');
        });
    }, { threshold: 0.1, rootMargin: '0px 0px -60px 0px' });
    document.querySelectorAll('.fade-in-up').forEach(el => observer.observe(el));
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\calton\Herd\kodehub\resources\views/portfolio/staffhub.blade.php ENDPATH**/ ?>