

<?php $__env->startSection('title', 'Admin Login | KodeHub'); ?>

<?php $__env->startSection('content'); ?>

<div style="min-height:100dvh; display:flex; align-items:center; justify-content:center; background:var(--paper-warm); padding:var(--gutter);">
    <div style="width:100%; max-width:420px;">

        <div style="text-align:center; margin-bottom:2.5rem;">
            <div style="display:inline-flex; align-items:center; gap:0.625rem; font-family:var(--font-display); font-size:1.5rem; font-weight:500; color:var(--ink);">
                <div class="logo-mark">KH</div>
                KodeHub
            </div>
            <p style="margin-top:1rem; font-size:0.9375rem; color:var(--ink-muted); font-weight:300;">
                Sign in to the admin panel
            </p>
        </div>

        <div style="background:white; border:1px solid var(--rule); padding:2.5rem;">

            <?php if($errors->any()): ?>
                <div style="background:rgba(192,57,43,0.07); border:1px solid rgba(192,57,43,0.2); padding:0.875rem 1.25rem; margin-bottom:1.5rem; font-size:0.9375rem; color:#c0392b; display:flex; align-items:center; gap:0.625rem;">
                    <i class="fa-solid fa-circle-exclamation fa-sm"></i>
                    Invalid email or password. Please try again.
                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('admin.login')); ?>">
                <?php echo csrf_field(); ?>

                <div class="form-field">
                    <label class="form-label">Email Address</label>
                    <input type="email"
                           name="email"
                           value="<?php echo e(old('email')); ?>"
                           class="form-input"
                           placeholder="admin@kodehub.com"
                           required
                           autofocus>
                </div>

                <div class="form-field">
                    <label class="form-label">Password</label>
                    <input type="password"
                           name="password"
                           class="form-input"
                           placeholder="••••••••"
                           required>
                </div>

                <button type="submit" class="btn btn-primary" style="width:100%; justify-content:center; margin-top:0.5rem;">
                    Sign In
                    <i class="fa-solid fa-arrow-right fa-xs"></i>
                </button>

            </form>
        </div>

        <p style="text-align:center; margin-top:1.5rem; font-size:0.875rem; color:var(--ink-faint);">
            <a href="<?php echo e(route('welcome')); ?>" style="color:var(--ink-muted); transition:color 0.15s;" onmouseover="this.style.color='var(--ink)'" onmouseout="this.style.color='var(--ink-muted)'">
                <i class="fa-solid fa-arrow-left fa-xs" style="margin-right:0.375rem;"></i>
                Back to website
            </a>
        </p>

    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\calton\Herd\kodehub\resources\views/admin/login.blade.php ENDPATH**/ ?>