

<?php $__env->startSection('title', 'Portfolio | KodeHub Admin'); ?>
<?php $__env->startSection('page_title', 'Portfolio Projects'); ?>

<?php $__env->startSection('content'); ?>

<div style="display:flex; align-items:center; justify-content:space-between; margin-bottom:1.5rem;">
    <p style="font-size:0.9375rem; color:var(--ink-muted);">Manage your portfolio case studies.</p>
    <a href="<?php echo e(url('/admin/projects/create')); ?>" class="admin-btn admin-btn--primary">
        <i class="fa-solid fa-plus fa-xs"></i>
        Add Project
    </a>
</div>

<div class="admin-card">
    <?php if($projects->isEmpty()): ?>
        <div style="text-align:center; padding:3rem; color:var(--ink-muted);">
            <i class="fa-solid fa-briefcase" style="font-size:2rem; margin-bottom:1rem; display:block; color:var(--ink-faint);"></i>
            No projects yet. Add your first one.
        </div>
    <?php else: ?>
        <table class="admin-table">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Client</th>
                    <th>URL</th>
                    <th>Added</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td style="font-weight:400;"><?php echo e($project->title); ?></td>
                    <td style="color:var(--ink-muted);"><?php echo e($project->client); ?></td>
                    <td>
                        <?php if($project->url): ?>
                            <a href="<?php echo e($project->url); ?>" target="_blank"
                               style="font-size:0.875rem; color:var(--accent);">
                                <?php echo e(parse_url($project->url, PHP_URL_HOST)); ?>

                                <i class="fa-solid fa-arrow-up-right-from-square fa-xs" style="margin-left:0.25rem;"></i>
                            </a>
                        <?php else: ?>
                            <span style="color:var(--ink-faint);">—</span>
                        <?php endif; ?>
                    </td>
                    <td style="color:var(--ink-muted); font-size:0.875rem;">
                        <?php echo e($project->created_at->format('d M Y')); ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\calton\Herd\kodehub\resources\views/admin/projects/index.blade.php ENDPATH**/ ?>