

<?php $__env->startSection('title', 'Picforest Photography | KodeHub Portfolio'); ?>
<?php $__env->startSection('meta_description', 'A refined portfolio and booking platform built by KodeHub for Picforest Photography—showcasing professional work, streamlining client management.'); ?>

<?php $__env->startSection('content'); ?>

<div class="page-hero page-hero--dark">
    <div class="container">
        <span class="eyebrow" style="color:var(--accent-light);">Portfolio &mdash; Photography Platform</span>
        <h1 class="page-hero__title" style="color:white; max-width:720px;">
            Picforest Photography
        </h1>
        <p class="page-hero__lead">
            A refined portfolio platform enabling professional photographers to showcase
            their work, manage client bookings, and automate their business operations.
        </p>
    </div>
</div>

<section style="background:var(--paper-warm); border-bottom:1px solid var(--rule);">
    <div class="container" style="padding-top:2.5rem; padding-bottom:2.5rem; display:flex; gap:4rem; flex-wrap:wrap;">
        <div>
            <p style="font-family:var(--font-mono); font-size:0.625rem; letter-spacing:0.14em; text-transform:uppercase; color:var(--ink-muted); margin-bottom:0.375rem;">Client</p>
            <p style="font-size:1rem; color:var(--ink);">Picforest Photography</p>
        </div>
        <div>
            <p style="font-family:var(--font-mono); font-size:0.625rem; letter-spacing:0.14em; text-transform:uppercase; color:var(--ink-muted); margin-bottom:0.375rem;">Category</p>
            <p style="font-size:1rem; color:var(--ink);">Web Platform</p>
        </div>
        <div>
            <p style="font-family:var(--font-mono); font-size:0.625rem; letter-spacing:0.14em; text-transform:uppercase; color:var(--ink-muted); margin-bottom:0.375rem;">Technologies</p>
            <p style="font-size:1rem; color:var(--ink);">Laravel, Vue.js, MySQL</p>
        </div>
        <div>
            <p style="font-family:var(--font-mono); font-size:0.625rem; letter-spacing:0.14em; text-transform:uppercase; color:var(--ink-muted); margin-bottom:0.375rem;">Delivered</p>
            <p style="font-size:1rem; color:var(--ink);">2023</p>
        </div>
    </div>
</section>

<section class="section bg-paper-cool">
    <div class="container container--narrow">

        <div style="margin-bottom:4rem;" class="reveal">
            <img src="https://images.unsplash.com/photo-1542744173-8e7e53415bb0?q=85&w=2000&auto=format&fit=crop"
                 alt="Picforest Photography Platform"
                 style="width:100%; height:480px; object-fit:cover;">
        </div>

        <div class="about-text-section reveal" style="padding-top:0; border-bottom:none;">
            <div>
                <span class="eyebrow">The Brief</span>
                <h2 class="about-text-section__heading" style="margin-top:0.75rem;">Challenge</h2>
            </div>
            <div class="about-text-section__body">
                <p>
                    Picforest needed a platform that would do more than display their portfolio—
                    it needed to convert prospective clients into bookings, manage gallery delivery,
                    and reduce the administrative overhead that was consuming hours each week.
                </p>
                <p>
                    The photography market is visually competitive, so the platform needed to
                    present work at the highest quality while remaining fast and accessible
                    on mobile devices, where the majority of potential clients first encounter
                    a photographer's work.
                </p>
            </div>
        </div>

        <div class="about-text-section reveal" style="padding-bottom:0;">
            <div>
                <span class="eyebrow">Our Work</span>
                <h2 class="about-text-section__heading" style="margin-top:0.75rem;">Solution</h2>
            </div>
            <div class="about-text-section__body">
                <p>
                    We built a custom Laravel application with a Vue.js front-end, featuring
                    lazy-loaded, optimized image galleries that maintain quality without
                    compromising page performance. The booking system integrates directly with
                    the portfolio, allowing prospective clients to move from viewing work to
                    submitting a booking enquiry without leaving the experience.
                </p>
                <p>
                    An admin dashboard gives the photographer full control over gallery management,
                    enquiry tracking, and client communication—all from a single, intuitive interface
                    that required no technical knowledge to operate.
                </p>
            </div>
        </div>

    </div>
</section>

<div class="cta-banner">
    <div class="cta-banner__inner">
        <h2 class="cta-banner__title">
            Want a platform like this
            <em>for your business?</em>
        </h2>
        <a href="<?php echo e(route('contact')); ?>" class="btn btn-primary">
            Discuss Your Project
            <i class="fa-solid fa-arrow-right fa-xs"></i>
        </a>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\calton\Herd\kodehub\resources\views/portfolio/picforest.blade.php ENDPATH**/ ?>