

<?php $__env->startSection('title', 'Messages | KodeHub Admin'); ?>
<?php $__env->startSection('page_title', 'Contact Messages'); ?>

<?php $__env->startSection('content'); ?>

<div class="admin-card">
    <div style="display:flex; align-items:center; justify-content:space-between; margin-bottom:1.5rem; padding-bottom:1rem; border-bottom:1px solid var(--rule);">
        <h2 style="font-family:var(--font-display); font-size:1.25rem; font-weight:400;">All Messages</h2>
        <span style="font-size:0.875rem; color:var(--ink-muted);"><?php echo e($messages->total() ?? 0); ?> total</span>
    </div>

    <?php if($messages->isEmpty()): ?>
        <div style="text-align:center; padding:3rem; color:var(--ink-muted);">
            <i class="fa-solid fa-inbox" style="font-size:2rem; margin-bottom:1rem; display:block; color:var(--ink-faint);"></i>
            No messages yet.
        </div>
    <?php else: ?>
        <table class="admin-table">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Service</th>
                    <th>Date</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                        <a href="<?php echo e(route('admin.messages.show', $msg)); ?>"
                           style="font-weight:400; color:var(--ink); transition:color 0.15s;"
                           onmouseover="this.style.color='var(--accent)'"
                           onmouseout="this.style.color='var(--ink)'">
                            <?php echo e($msg->name); ?>

                        </a>
                    </td>
                    <td style="color:var(--ink-muted);"><?php echo e($msg->email); ?></td>
                    <td>
                        <?php if($msg->service): ?>
                            <span class="admin-badge"><?php echo e($msg->service); ?></span>
                        <?php else: ?>
                            <span style="color:var(--ink-faint); font-size:0.875rem;">—</span>
                        <?php endif; ?>
                    </td>
                    <td style="color:var(--ink-muted); font-size:0.875rem;"><?php echo e($msg->created_at->format('d M Y')); ?></td>
                    <td>
                        <?php if(!$msg->is_read): ?>
                            <span style="display:inline-flex; align-items:center; gap:0.375rem; font-size:0.8125rem; color:var(--accent);">
                                <span style="width:6px; height:6px; background:var(--accent); border-radius:50%;"></span>
                                New
                            </span>
                        <?php else: ?>
                            <span style="font-size:0.8125rem; color:var(--ink-faint);">Read</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <div style="margin-top:1.5rem; padding-top:1.25rem; border-top:1px solid var(--rule);">
            <?php echo e($messages->links()); ?>

        </div>
    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\calton\Herd\kodehub\resources\views/admin/messages/index.blade.php ENDPATH**/ ?>