

<?php $__env->startSection('title', 'Portfolio | KodeHub — Selected Work & Case Studies'); ?>
<?php $__env->startSection('meta_description', 'Explore KodeHub\'s portfolio of web platforms, mobile applications, enterprise systems, and POS solutions delivered for clients across Kenya.'); ?>

<?php $__env->startSection('content'); ?>


<div class="page-hero page-hero--dark">
    <div class="container">
        <span class="eyebrow" style="color:var(--accent-light);">Selected Work</span>
        <h1 class="page-hero__title" style="color:white;">
            Projects we're
            <em style="font-style:italic; color:var(--accent-light);">proud of.</em>
        </h1>
        <p class="page-hero__lead">
            A curated selection of engagements showcasing our commitment to craft,
            our range of capabilities, and the measurable impact of well-built software.
        </p>
    </div>
</div>


<section class="section bg-paper-cool">
    <div class="container">

        <div class="portfolio-grid">

            <a href="<?php echo e(route('portfolio.picforest')); ?>" class="portfolio-item reveal">
                <img src="https://images.unsplash.com/photo-1542744173-8e7e53415bb0?q=80&w=2070&auto=format&fit=crop"
                     alt="Picforest Photography Platform"
                     class="portfolio-item__img">
                <div class="portfolio-item__overlay">
                    <div class="portfolio-item__tag">Photography Platform &mdash; Web</div>
                    <h3 class="portfolio-item__title">Picforest Photography</h3>
                </div>
            </a>

            <a href="<?php echo e(route('portfolio.amicabre')); ?>" class="portfolio-item reveal reveal-delay-1">
                <img src="https://images.unsplash.com/photo-1449965408869-eaa3f722e40d?q=80&w=1200&auto=format&fit=crop"
                     alt="Amicabre Travels Fleet System"
                     class="portfolio-item__img">
                <div class="portfolio-item__overlay">
                    <div class="portfolio-item__tag">Fleet Management &mdash; Web</div>
                    <h3 class="portfolio-item__title">Amicabre Travels</h3>
                </div>
            </a>

            <a href="<?php echo e(route('portfolio.staffhub')); ?>" class="portfolio-item reveal">
                <img src="https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?q=80&w=1200&auto=format&fit=crop"
                     alt="StaffHub HR Management"
                     class="portfolio-item__img">
                <div class="portfolio-item__overlay">
                    <div class="portfolio-item__tag">HR Management &mdash; Web</div>
                    <h3 class="portfolio-item__title">StaffHub</h3>
                </div>
            </a>

            <a href="#" class="portfolio-item reveal reveal-delay-1">
                <img src="https://images.unsplash.com/photo-1551288049-bebda4e38f71?q=80&w=2070&auto=format&fit=crop"
                     alt="Enterprise ERP Solution"
                     class="portfolio-item__img">
                <div class="portfolio-item__overlay">
                    <div class="portfolio-item__tag">Enterprise ERP &mdash; Custom System</div>
                    <h3 class="portfolio-item__title">Enterprise ERP Solution</h3>
                </div>
            </a>

            <a href="#" class="portfolio-item reveal">
                <img src="https://images.unsplash.com/photo-1556742400-b5b7f926f8fb?q=80&w=1200&auto=format&fit=crop"
                     alt="Multi-Location POS System"
                     class="portfolio-item__img">
                <div class="portfolio-item__overlay">
                    <div class="portfolio-item__tag">Point of Sale &mdash; Retail</div>
                    <h3 class="portfolio-item__title">Retail POS Platform</h3>
                </div>
            </a>

            <a href="#" class="portfolio-item reveal reveal-delay-1">
                <img src="https://images.unsplash.com/photo-1501504905252-473c47e087f8?q=80&w=1200&auto=format&fit=crop"
                     alt="Learning Management Platform"
                     class="portfolio-item__img">
                <div class="portfolio-item__overlay">
                    <div class="portfolio-item__tag">EdTech &mdash; Web Platform</div>
                    <h3 class="portfolio-item__title">Learning Management Platform</h3>
                </div>
            </a>

        </div>

    </div>
</section>


<section class="section bg-paper-warm border-top">
    <div class="container">

        <div class="section-header--center reveal">
            <span class="eyebrow">Capabilities</span>
            <h2 class="section-title">What every project includes</h2>
            <p class="section-lead">
                Beyond the feature set—these are the non-negotiable qualities
                we bring to every engagement.
            </p>
        </div>

        <div class="values-grid">
            <div class="value-card reveal">
                <div class="value-card__icon"><i class="fa-solid fa-pen-ruler"></i></div>
                <h3 class="value-card__title">Bespoke Design</h3>
                <p class="value-card__desc">Interfaces built for your brand and your users—never adapted from a generic template.</p>
            </div>
            <div class="value-card reveal reveal-delay-1">
                <div class="value-card__icon"><i class="fa-solid fa-gauge-high"></i></div>
                <h3 class="value-card__title">Measurable Performance</h3>
                <p class="value-card__desc">Every build is benchmarked against real-world performance targets before delivery.</p>
            </div>
            <div class="value-card reveal reveal-delay-2">
                <div class="value-card__icon"><i class="fa-solid fa-lock"></i></div>
                <h3 class="value-card__title">Enterprise Security</h3>
                <p class="value-card__desc">Security-first development practices protecting your data and your users at every layer.</p>
            </div>
            <div class="value-card reveal">
                <div class="value-card__icon"><i class="fa-solid fa-arrow-up-right-dots"></i></div>
                <h3 class="value-card__title">Scalable Architecture</h3>
                <p class="value-card__desc">Designed to grow from your first users to your hundredth thousand without architectural debt.</p>
            </div>
            <div class="value-card reveal reveal-delay-1">
                <div class="value-card__icon"><i class="fa-solid fa-book-open"></i></div>
                <h3 class="value-card__title">Full Documentation</h3>
                <p class="value-card__desc">Comprehensive technical documentation delivered alongside every project for future maintainability.</p>
            </div>
            <div class="value-card reveal reveal-delay-2">
                <div class="value-card__icon"><i class="fa-solid fa-headset"></i></div>
                <h3 class="value-card__title">Post-Launch Support</h3>
                <p class="value-card__desc">We remain engaged after handover—monitoring, responding, and evolving alongside your needs.</p>
            </div>
        </div>

    </div>
</section>


<div class="cta-banner">
    <div class="cta-banner__inner">
        <h2 class="cta-banner__title">
            Your project could be
            <em>our next case study.</em>
        </h2>
        <a href="<?php echo e(route('contact')); ?>" class="btn btn-primary">
            Discuss Your Project
            <i class="fa-solid fa-arrow-right fa-xs"></i>
        </a>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\calton\Herd\kodehub\resources\views/pages/portfolio.blade.php ENDPATH**/ ?>